/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.common.base.Optional;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public class BuildBlock {
    public BlockPos blockPos;
    @Expose
    private String blockDomain;
    @Expose
    private String blockName;
    @Expose
    private PositionOffset startingPosition;
    @Expose
    private ArrayList<BuildProperty> properties;
    @Expose
    private BuildBlock subBlock;
    @Expose
    private boolean hasFacing;
    @Expose
    private IBlockState state;
    @Expose
    private String blockStateData;

    public BuildBlock() {
        this.Initialize();
    }

    public static BuildBlock SetBlockState(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, BuildBlock block, Block foundBlock, IBlockState blockState, Structure structure) {
        try {
            if (!block.blockStateData.equals("")) {
                return BuildBlock.SetBlockStateFromTagData(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
            }
            EnumFacing vineFacing = BuildBlock.getVineFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            BlockLog.EnumAxis logFacing = BuildBlock.getLogFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            EnumFacing.Axis boneFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            BlockQuartz.EnumType quartzFacing = BuildBlock.getQuartsFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            BlockLever.EnumOrientation leverOrientation = BuildBlock.getLeverOrientation(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            if (block.getProperties().size() > 0) {
                Collection properties = blockState.func_177227_a();
                for (IProperty property : properties) {
                    BuildProperty buildProperty = block.getProperty(property.func_177701_a());
                    if (buildProperty == null) continue;
                    try {
                        Optional propertyValue = property.func_185929_b(buildProperty.getValue());
                        if (!propertyValue.isPresent() || propertyValue.getClass().getName().equals("com.google.common.base.Absent")) {
                            FMLLog.log.warn("Property value for property name [" + property.func_177701_a() + "] for block [" + block.getBlockName() + "] is considered Absent, figure out why.");
                            continue;
                        }
                        Comparable comparable = (Comparable)property.func_177699_b().cast(propertyValue.get());
                        if (comparable == null || (comparable = BuildBlock.setComparable(comparable, foundBlock, property, configuration, block, assumedNorth, propertyValue, vineFacing, logFacing, boneFacing, quartzFacing, leverOrientation, structure)) == null) continue;
                        try {
                            if (blockState.func_177229_b(property) == comparable) continue;
                            blockState = BuildBlock.setProperty(blockState, property, comparable);
                        }
                        catch (Exception ex) {
                            System.out.println("Error setting properly value for property name [" + property.func_177701_a() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "] The default value will be used.");
                        }
                    }
                    catch (Exception ex) {
                        if (property == null || buildProperty == null) continue;
                        System.out.println("Error getting properly value for property name [" + property.func_177701_a() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "]");
                        throw ex;
                    }
                }
            }
            block.setBlockState(blockState);
            return block;
        }
        catch (Exception ex) {
            System.out.println("Error setting block state for block [" + block.getBlockName() + "] for structure configuration class [" + configuration.getClass().getName() + "]");
            throw ex;
        }
    }

    public static EnumFacing getHorizontalFacing(EnumFacing currentFacing, EnumFacing configurationFacing, EnumFacing structureDirection) {
        if (currentFacing != null && currentFacing != EnumFacing.UP && currentFacing != EnumFacing.DOWN) {
            if (configurationFacing.func_176734_d() == structureDirection.func_176746_e()) {
                currentFacing = currentFacing.func_176746_e();
            } else if (configurationFacing.func_176734_d() == structureDirection.func_176734_d()) {
                currentFacing = currentFacing.func_176734_d();
            } else if (configurationFacing.func_176734_d() == structureDirection.func_176735_f()) {
                currentFacing = currentFacing.func_176735_f();
            }
        }
        return currentFacing;
    }

    private static Comparable setComparable(Comparable<?> comparable, Block foundBlock, IProperty<?> property, StructureConfiguration configuration, BuildBlock block, EnumFacing assumedNorth, Optional<?> propertyValue, EnumFacing vineFacing, BlockLog.EnumAxis logFacing, EnumFacing.Axis boneFacing, BlockQuartz.EnumType quartzFacing, BlockLever.EnumOrientation leverOrientation, Structure structure) {
        if (property.func_177701_a().equals("facing") && !(foundBlock instanceof BlockLever)) {
            EnumFacing facing = EnumFacing.func_176739_a((String)propertyValue.get().toString());
            facing = BuildBlock.getHorizontalFacing(facing, configuration.houseFacing, structure.getClearSpace().getShape().getDirection());
            comparable = facing;
            block.setHasFacing(true);
        } else if (property.func_177701_a().equals("facing") && foundBlock instanceof BlockLever) {
            comparable = leverOrientation;
            block.setHasFacing(true);
        } else if (property.func_177701_a().equals("rotation")) {
            EnumFacing facing;
            int rotation = (Integer)propertyValue.get();
            EnumFacing enumFacing = rotation == 0 ? EnumFacing.SOUTH : (rotation == 4 ? EnumFacing.WEST : (facing = rotation == 8 ? EnumFacing.NORTH : EnumFacing.EAST));
            if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176746_e()) {
                facing = facing.func_176746_e();
            } else if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176734_d()) {
                facing = facing.func_176734_d();
            } else if (configuration.houseFacing.func_176734_d() == structure.getClearSpace().getShape().getDirection().func_176735_f()) {
                facing = facing.func_176735_f();
            }
            rotation = facing == EnumFacing.SOUTH ? 0 : (facing == EnumFacing.WEST ? 4 : (facing == EnumFacing.NORTH ? 8 : 12));
            comparable = rotation;
            block.setHasFacing(true);
        } else if (foundBlock instanceof BlockVine) {
            if (property.func_177701_a().equals(vineFacing.func_176742_j())) {
                comparable = true;
                block.setHasFacing(true);
            } else {
                comparable = false;
            }
        } else if (foundBlock instanceof BlockWall) {
            if (!property.func_177701_a().equals("variant")) {
                if (property.func_177701_a().equals(vineFacing.func_176742_j()) || property.func_177701_a().equals(vineFacing.func_176734_d().func_176742_j())) {
                    comparable = true;
                    block.setHasFacing(true);
                } else {
                    comparable = false;
                }
            }
        } else if (foundBlock instanceof BlockLog) {
            if (property.func_177701_a().equals("axis")) {
                comparable = logFacing;
            }
        } else if (foundBlock instanceof BlockBone) {
            if (property.func_177701_a().equals("axis")) {
                comparable = boneFacing;
            }
        } else if (foundBlock instanceof BlockQuartz && property.func_177701_a().equals("variant") && quartzFacing != BlockQuartz.EnumType.DEFAULT) {
            comparable = quartzFacing;
        }
        return comparable;
    }

    private static EnumFacing getVineFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, EnumFacing assumedNorth) {
        EnumFacing vineFacing = EnumFacing.UP;
        if (foundBlock instanceof BlockVine || foundBlock instanceof BlockWall) {
            if (block.getProperty("east").getValue().equals("true")) {
                vineFacing = EnumFacing.EAST;
            } else if (block.getProperty("west").getValue().equals("true")) {
                vineFacing = EnumFacing.WEST;
            } else if (block.getProperty("south").getValue().equals("true")) {
                vineFacing = EnumFacing.SOUTH;
            } else if (block.getProperty("north").getValue().equals("true")) {
                vineFacing = EnumFacing.NORTH;
            }
            if (vineFacing != EnumFacing.UP) {
                if (configuration.houseFacing.func_176746_e() == assumedNorth) {
                    vineFacing = vineFacing.func_176746_e();
                } else if (configuration.houseFacing.func_176734_d() != assumedNorth) {
                    vineFacing = configuration.houseFacing.func_176735_f() == assumedNorth ? vineFacing.func_176735_f() : vineFacing.func_176734_d();
                }
            }
        }
        return vineFacing;
    }

    private static BlockLog.EnumAxis getLogFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, EnumFacing assumedNorth) {
        BlockLog.EnumAxis logFacing = BlockLog.EnumAxis.X;
        if (foundBlock instanceof BlockLog && (logFacing = block.getProperty("axis").getValue().equals("x") ? BlockLog.EnumAxis.X : (block.getProperty("axis").getValue().equals("y") ? BlockLog.EnumAxis.Y : BlockLog.EnumAxis.Z)) != BlockLog.EnumAxis.Y) {
            logFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? logFacing : (logFacing == BlockLog.EnumAxis.X ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X);
        }
        return logFacing;
    }

    private static EnumFacing.Axis getBoneFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, EnumFacing assumedNorth) {
        EnumFacing.Axis boneFacing = EnumFacing.Axis.X;
        if (foundBlock instanceof BlockBone && (boneFacing = block.getProperty("axis").getValue().equals("x") ? EnumFacing.Axis.X : (block.getProperty("axis").getValue().equals("y") ? EnumFacing.Axis.Y : EnumFacing.Axis.Z)) != EnumFacing.Axis.Y) {
            boneFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? boneFacing : (boneFacing == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
        }
        return boneFacing;
    }

    private static BlockQuartz.EnumType getQuartsFacing(StructureConfiguration configuration, Block foundBlock, BuildBlock block, EnumFacing assumedNorth) {
        BlockQuartz.EnumType quartzFacing = BlockQuartz.EnumType.DEFAULT;
        if (foundBlock instanceof BlockQuartz && block.getProperty("variant").getValue().startsWith("lines")) {
            if (block.getProperty("variant").getValue().equals("lines_x")) {
                quartzFacing = BlockQuartz.EnumType.LINES_X;
            } else if (block.getProperty("variant").getValue().equals("lines_z")) {
                quartzFacing = BlockQuartz.EnumType.LINES_Z;
            }
            if (quartzFacing == BlockQuartz.EnumType.LINES_X || quartzFacing == BlockQuartz.EnumType.LINES_Z) {
                quartzFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing.func_176734_d() == assumedNorth ? quartzFacing : (quartzFacing == BlockQuartz.EnumType.LINES_X ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X);
            }
        }
        return quartzFacing;
    }

    private static BlockLever.EnumOrientation getLeverOrientation(StructureConfiguration configuration, Block foundBlock, BuildBlock block, EnumFacing assumedNorth) {
        BlockLever.EnumOrientation leverOrientation = BlockLever.EnumOrientation.NORTH;
        if (foundBlock instanceof BlockLever) {
            leverOrientation = BlockLever.EnumOrientation.valueOf((String)block.getProperty("facing").getValue().toUpperCase());
            if (leverOrientation.func_176852_c() == EnumFacing.DOWN || leverOrientation.func_176852_c() == EnumFacing.UP) {
                leverOrientation = leverOrientation.func_176852_c() == EnumFacing.DOWN ? (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? leverOrientation : (leverOrientation == BlockLever.EnumOrientation.DOWN_X ? BlockLever.EnumOrientation.DOWN_Z : BlockLever.EnumOrientation.DOWN_X)) : (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.func_176734_d() ? leverOrientation : (leverOrientation == BlockLever.EnumOrientation.UP_X ? BlockLever.EnumOrientation.UP_Z : BlockLever.EnumOrientation.UP_X));
            } else {
                EnumFacing facing = leverOrientation.func_176852_c();
                if (configuration.houseFacing.func_176746_e() == assumedNorth) {
                    facing = facing.func_176746_e();
                } else if (configuration.houseFacing.func_176734_d() != assumedNorth) {
                    facing = configuration.houseFacing.func_176735_f() == assumedNorth ? facing.func_176735_f() : facing.func_176734_d();
                }
                for (BlockLever.EnumOrientation tempOrientation : BlockLever.EnumOrientation.values()) {
                    if (tempOrientation.func_176852_c() != facing) continue;
                    leverOrientation = tempOrientation;
                    break;
                }
            }
        }
        return leverOrientation;
    }

    private static IBlockState setProperty(IBlockState state, IProperty property, Comparable comparable) {
        return state.func_177226_a(property, comparable);
    }

    private static BuildBlock SetBlockStateFromTagData(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, BuildBlock block, Block foundBlock, IBlockState blockState, Structure structure) {
        IBlockState tagState = block.getBlockStateFromDataTag();
        if (tagState == null) {
            block.setBlockStateData("");
            return BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
        }
        block.setBlockState(block.getBlockStateFromDataTag());
        return block;
    }

    public String getBlockDomain() {
        return this.blockDomain;
    }

    public void setBlockDomain(String value) {
        this.blockDomain = value;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String value) {
        this.blockName = value;
    }

    public ResourceLocation getResourceLocation() {
        ResourceLocation location = new ResourceLocation(this.blockDomain, this.blockName);
        return location;
    }

    public PositionOffset getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(PositionOffset value) {
        this.startingPosition = value;
    }

    public ArrayList<BuildProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<BuildProperty> value) {
        this.properties = value;
    }

    public BuildProperty getProperty(String name) {
        for (BuildProperty property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public BuildBlock getSubBlock() {
        return this.subBlock;
    }

    public void setSubBlock(BuildBlock value) {
        this.subBlock = value;
    }

    public boolean getHasFacing() {
        return this.hasFacing;
    }

    public void setHasFacing(boolean value) {
        this.hasFacing = value;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public void setBlockState(IBlockState value) {
        this.state = value;
    }

    public String getBlockStateData() {
        return this.blockStateData;
    }

    public void setBlockStateData(String value) {
        this.blockStateData = value;
    }

    public void setBlockStateData(NBTTagCompound tagCompound) {
        this.blockStateData = tagCompound.toString();
    }

    public NBTTagCompound getBlockStateDataTag() {
        NBTTagCompound tag = null;
        if (!this.blockStateData.equals("")) {
            try {
                tag = JsonToNBT.func_180713_a((String)this.blockStateData);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        return tag;
    }

    public IBlockState getBlockStateFromDataTag() {
        NBTTagCompound tag;
        IBlockState state = null;
        if (!this.blockStateData.equals("") && (tag = this.getBlockStateDataTag()) != null) {
            state = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("tag"));
        }
        return state;
    }

    public void Initialize() {
        this.blockDomain = "";
        this.blockName = "";
        this.properties = new ArrayList();
        this.hasFacing = false;
        this.state = null;
        this.subBlock = null;
        this.startingPosition = new PositionOffset();
        this.blockStateData = "";
    }
}

